<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
* @filesource
*/ /** */

require_once 'restricted_controller.php';

/**
* @package direct-project-innovation-initiative
* @subpackage controllers
*/
class Settings extends Restricted_controller {
	
	public function index()
	{	
		$response = $this->get_user_ldap_info();
		if($response->http_status === 200){
			$user_data = $response->response;
			$data = get_object_vars($user_data);			
			$data["title"] = PORTAL_TITLE_PREFIX . "User Settings";
			$this->load->view("settings/index",$data);
		}else{
			$this->session->set_error_message('You have not granted this application manage permissions.');
			redirect('settings/application');
		}
	}
	
	public function notifications()
	{	
		$this->load->database();
		$data = $this->get_user_db_info();
			
		$data["title"] = PORTAL_TITLE_PREFIX . "User Settings";
		//pass group mailbox info if there is any
		$group_mailboxes = $this->session->userdata('group_mailboxes');
		if(is_array($group_mailboxes)) { $data['group_mailboxes'] = $group_mailboxes; }
		//pass personal mailbox hidden data
		$data['hide_personal_mailbox'] = FALSE;
		if($this->session->userdata('hide_personal_mailbox') !== FALSE) { $data['hide_personal_mailbox'] = TRUE; }
		//load view
		$this->load->view("settings/notifications",$data);
	}
	
	public function application() {
		$data['countries'] = $this->locale->get_countries();
		
		if($this->user->user_locale) 
			$locale = unserialize($this->user->user_locale);
		else
			$locale = array('country' => ENVIRONMENT_COUNTRY, 'timezone' => $this->locale->get_id_from_timezone(ENVIRONMENT_TIMEZONE));
		
		if(!empty($locale['country']))
			$timezones = DateTimeZone::listIdentifiers(DateTimeZone::PER_COUNTRY, $locale['country']);
		else
			$timezones = DateTimeZone::listIdentifiers();
				
		$data['timezones'] = array();
		foreach($timezones as $timezone) {;
			$timezone_obj = new DateTimeZone($timezone);
			$gmt = new DateTimeZone('GMT');
			$time = new DateTime('now',$gmt);
			$offset = $timezone_obj->getOffset($time) / 3600;
			//print_r(timezone_abbreviations_list());
			$tmp['offset'] = $offset;
			$tmp['timezone'] = $timezone;
			
			array_push($data['timezones'],$tmp);
		}
		
		usort($data['timezones'], array('Settings', 'timezone_cmp')); //sort timezone array
		$data['current_country'] = $locale['country'];
		$data['current_timezone'] = $this->locale->get_timezone_from_id($locale['timezone']);
					
		$data['username'] = $this->user->username;
		$data['title'] = PORTAL_TITLE_PREFIX . ' Test Application Settings';
		$this->load->view('settings/application',$data);
	}
	
	public function ajax_timezone_list($country = NULL) {
		if(!isset($country)) { return FALSE; }
		$timezones = DateTimeZone::listIdentifiers(DateTimeZone::PER_COUNTRY, $country);
		
		$this->load->library('locale');
		$locale_query = $this->db->query('SELECT user_locale FROM users WHERE user_id='.$this->db->escape($this->get_user_id($this->session->userdata('username'))));
		if($locale_query) {
			$locale = $locale_query->row_array();
			$locale = unserialize($locale['user_locale']);
			$current_timezone = $this->locale->get_timezone_from_id($locale['timezone']);
		}
		
		$options = array();
		foreach($timezones as $timezone) {
			$timezone_obj = new DateTimeZone($timezone);
			$time = new DateTime('now',$timezone_obj);
			$offset = $timezone_obj->getOffset($time) / 3600;
			
			$option_array['offset'] = $offset;
			$option_array['value'] = $timezone;
			$option_array['text'] = str_replace('_',' ',$timezone) . ' ' . '(GMT ' . ($offset < 0 ? $offset : '+'.$offset) . ':00) '. $this->locale->timezone_abbr_from_name($timezone);

			//mark current timezone as selected if necessary
			if(isset($current_timezone) && $current_timezone == $timezone) { $option_array['selected'] = TRUE; }
			else { $option_array['selected'] = FALSE;}
			//add to array of timezone options
			array_push($options,$option_array);
		}
		//sort timezone array
		usort($options,array("Settings","timezone_cmp"));
		//don't give this information out unless it was requested by ajax
		if(IS_AJAX) { echo json_encode($options); }
	}
	
	public function update_app_settings() {
		$this->load->database();
		//get post values
		$country = $this->input->post('country',TRUE);
		$timezone = $this->input->post('timezone',TRUE);
		//set locale settings
		$this->load->library('locale');
		$locale['country'] = $country;
		$locale['timezone'] = $this->locale->get_id_from_timezone($timezone);
		$this->db->query('UPDATE users SET user_locale='.$this->db->escape(serialize($locale)).' WHERE user_id='.$this->db->escape($this->get_user_id($this->session->userdata('username'))));
		
		$this->session->set_sucess_message('Locale settings successfully updated.');
		redirect('settings/application');
	}
	
	public function update_account_info() {
		$this->form_validation->set_rules("first_name","First Name","required","xss_clean");
		$this->form_validation->set_rules("last_name","Last Name","required","xss_clean");
		$this->form_validation->set_rules("facility_id","Facility","required","xss_clean");
		
		if($this->form_validation->run() == true) {			
			//capture input
			$first = $this->input->post("first_name",TRUE);
			$last = $this->input->post("last_name",TRUE);
			$middle = $this->input->post("middle_name",TRUE);
			$title = $this->input->post("job_title",TRUE);
			$department = $this->input->post("department",TRUE);
			$organization = $this->input->post("organization",TRUE);
			$telephone = $this->input->post("telephone",TRUE);
			$mobile = $this->input->post("mobile",TRUE);
			$location = $this->input->post("location",TRUE);
			
			$attributes = array();
			//add mandatory attrs to array
			$attributes["givenName"] = $first;
			$attributes["sn"] = $last;
			$attributes["cn"] = $first . " " . $last;
			
			//deal with optional attributes (middle name is a sepcial case, since we need to change displayName based on it too)
			if(isset($middle) && strlen($middle) > 0) { $attributes["initials"] = $middle; $attributes["displayName"] = $last . ", " . $first . " " . $middle; }
			else { $attributes["initials"] = ""; $attributes["displayName"] = $last . ", " . $first; }
			if(isset($title)) { $attributes["title"] = $title; }
			if(isset($department)) { $attributes["departmentnumber"] = $department; }
			if(isset($organization)) { $attributes["o"] = $organization; }
			if(isset($telephone)) { $attributes["telephonenumber"] = $telephone; }
			if(isset($mobile)) { $attributes["mobile"] = $mobile; }
			if(isset($location)) { $attributes["physicaldeliveryofficename"] = $location; }
			
			$modified = $this->ldap->modify_ldap_account($this->session->userdata("username"),$attributes);
			if($modified) {
				$resource = '/direct/account/update/format/json';
				$fields = $this->input->post(NULL, TRUE);
				//construct post request
				$fields ['mailbox'] = $this->session->userdata("username");
				$post = '';
				foreach($fields as $key => $value) { $post .= $key.'='.urlencode($value).'&'; } //url-ify the data for the POST
				$post = rtrim($post, '&');
				
				$response = $this->api_model->webservice_call($resource,'POST',$post);
				if($response->http_status === 200) {
					$this->session->set_success_message('Account information successfully updated.');
					
					//if we reach this point presumably it was successful
					$this->session->set_userdata('user_cn',$attributes['cn']); //update user's name in session
					$get_actor_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag = 0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
					if($get_actor_id) {
						$actor_id_row = $get_actor_id->row_array();
						$actor_id = $actor_id_row["user_id"];
						$target_id = $actor_id;
						$this->load->library("audit");
						$this->audit->log_event("edit",array($target_id,$actor_id,"Update user information",date('U')));
					}
					redirect('settings');
				}
				else{
					$this->session->set_error_message($response->response->message);
					redirect('settings');
				}
			}
			else {
				$this->session->set_error_message('Account information failed to update.');
				redirect('settings');
			}
		}
		else {
			$first_name_error = (strlen(form_error('first_name')) > 0) ? form_error('first_name') : null;
			$last_name_error = (strlen(form_error('last_name')) > 0) ? form_error('last_name') : null;
			$facility_id_error = (strlen(form_error('facility_id')) > 0) ? form_error('facility_id') : null;
			$validation_errors = array('first_name'=>$first_name_error,'last_name'=>$last_name_error,'facility_id'=>$facility_id_error);
			$this->session->set_flashdata('validation_errors',$validation_errors);
			redirect('settings');
		}
	}
	
	public function update_notifications() {
		$this->load->database();
		
		$this->form_validation->set_rules("ext_mail","External Email","required|callback_va_email","xss_clean");
		if($this->form_validation->run() == true) {
			$get_user_id = $this->db->query("SELECT user_id FROM users WHERE user_name=" . $this->db->escape($this->session->userdata("username")));
			if($get_user_id) { 
				if($get_user_id->num_rows == 1) { 
					$row = $get_user_id->row_array();
					$user_id = $row["user_id"];
				}
			}
			if(isset($user_id)) {
				$ext_mail = $this->input->post("ext_mail",TRUE);
				if(array_key_exists("notify",$this->input->post(NULL,TRUE)) && array_key_exists('group_notify',$this->input->post(NULL,TRUE))) {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=1, user_ext_group_notify_flag=1 WHERE user_id=" . $this->db->escape($user_id));
				}
				else if(array_key_exists('notify',$this->input->post(NULL,TRUE))) {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=1, user_ext_group_notify_flag=0 WHERE user_id=" . $this->db->escape($user_id));
				}
				else if(array_key_exists('group_notify',$this->input->post(NULL,TRUE))) {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=0, user_ext_group_notify_flag=1 WHERE user_id=" . $this->db->escape($user_id));
				}
				else {
					$this->db->query("UPDATE users SET user_mail =" . $this->db->escape($ext_mail) . ", user_ext_notify_flag=0, user_ext_group_notify_flag=0 WHERE user_id=" . $this->db->escape($user_id));
				}
				
				//if we reach this point presumably it was successful
				$get_actor_id = $this->db->query("SELECT user_id FROM users WHERE user_deleted_flag = 0 AND user_name=" . $this->db->escape($this->session->userdata("username")));
				if($get_actor_id) {
					$actor_id_row = $get_actor_id->row_array();
					$actor_id = $actor_id_row["user_id"];
					$target_id = $actor_id;
					$this->load->library("audit");
					$this->audit->log_event("edit",array($target_id,$actor_id,"Update user information",date('U')));
				}
				$this->session->set_success_message('Settings successfully updated.');
				redirect('settings/notifications');
			}
			else {
				$this->session->set_error_message('Failed to update settings.');
				redirect('settings/notifications');
			}
		}
		else {
			$ext_mail_error = (strlen(form_error('ext_mail')) > 0) ? form_error('ext_mail') : null;
			$validation_errors = array('ext_mail'=>$ext_mail_error);
			$this->session->set_flashdata('validation_errors',$validation_errors);
			redirect('settings/notifications');
		}
	}
	
	private function get_user_db_info() {
		$user = User::find_from_session();
		if(!User::is_an_entity($user)) return false;
		
		$data = array('ext_mail' => $user->user_mail,
					  'notify' => $user->user_ext_notify_flag,
					  'group_notify' => $user->user_ext_group_notify_flag);
		
		//pass group mailbox info if there is any
		$group_mailboxes = $this->session->userdata('group_mailboxes');
		if(is_array($group_mailboxes)) { $data['group_mailboxes'] = $group_mailboxes; }
		
		//pass personal mailbox hidden data
		$data['hide_personal_mailbox'] = FALSE;
		if($this->session->userdata('hide_personal_mailbox') !== FALSE) { $data['hide_personal_mailbox'] = TRUE; }
		
		return $data;
	}
	
	private function get_user_ldap_info() {
		$resource = '/direct/account/mailbox/'.$this->session->userdata('username');
		$resource .= '/format/json';
		return $this->api_model->webservice_call($resource,'GET');
	}
	
	
	public function timezone_cmp($arr_a,$arr_b) {
		if($arr_a['offset'] > $arr_b['offset']) { return -1; }
		else if($arr_a['offset'] < $arr_b['offset']) { return 1; }
		else if($arr_a['offset'] == $arr_b['offset']) { return 0; }
	}
	
	public function va_email($email) {

		$valid = (preg_match("/^([a-z0-9\+_\-]+)(\.[a-z0-9\+_\-]+)*@+((.*(\.va\.gov))|va\.gov)$/ix", $email)) ? TRUE : FALSE;
		
		if($valid) { return TRUE; }
		$this->form_validation->set_message('va_email', 'The %s field must contain a valid domain email address.');
		return FALSE;
	}
}

/* End of file settings.php */
/* Location: ./application/controllers/settings.php */
